/*
* Creation date : Tues Mar 03 09:00:00 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains implementation of 
* XTS-AES functions. 
*
* \version CE2_XTS_AES.c#1:csrc:1
* \author Yermalayeu Ihar
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Include Files ***********************/

#include "LLF_XTS_AES.h"

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Global Data *************************/
/************************ Private function prototype **********/
/************************ Private Functions *******************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  DX_XTS_AES
*
* @param Key1_ptr [in] - This parameter is a first AES key used for XTS-AES cipher.
* @param Key2_ptr [in] - This parameter is a second AES key used for XTS-AES cipher.
* @param KeySize [in] - Size of first and second AES keys.
* @param SectorNumber [in] - 64-bit sector number.
* @param EncryptDecryptFlag [in] - This flag specialize encrypt or decrypt operation.
* @param DataIn_ptr [in] - A pointer to input data.
* @param DataInSize [in] - Size of input data. It must be at least 16 bytes.
* @param DataOut_ptr [out] - A pointer to output data.
*
* @returns \b
*  CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*   - CE2_XTS_AES_ILLEGAL_KEY1_PTR_ERROR
*   - CE2_XTS_AES_ILLEGAL_KEY2_PTR_ERROR
*   - CE2_XTS_AES_ILLEGAL_KEY_SIZE_ERROR
*   - CE2_XTS_AES_ILLEGAL_ENCRYPT_MODE_ERROR
*   - CE2_XTS_AES_ILLEGAL_DATAIN_PTR_ERROR
*   - CE2_XTS_AES_TO_SHORT_DATA_SIZE_ERROR
*   - CE2_XTS_AES_ILLEGAL_DATAOUT_PTR_ERROR
*
* \brief \b 
* Description:
*  This function is used to make XTS-AES operations;
*
*  \b 
* Algorithm:
*  -# Verify input parameters;
*  -# Call low level function LLF_XTS_AES().
***************************************************************/
CIMPORT_C CE2Error_t DX_XTS_AES(CE2_AES_Key_t           Key1_ptr,
																CE2_AES_Key_t           Key2_ptr,
																CE2_AES_KeySize_t       KeySize,
																DxUint64_t							SectorNumber,
																CE2_AES_EncryptMode_t   EncryptDecryptFlag, 
																DxUint8_t               *DataIn_ptr,        
																DxUint32_t              DataInSize,         
																DxUint8_t               *DataOut_ptr)
{
	if (Key1_ptr == DX_NULL)
		return CE2_XTS_AES_ILLEGAL_KEY1_PTR_ERROR;

	if (Key2_ptr == DX_NULL)
		return CE2_XTS_AES_ILLEGAL_KEY2_PTR_ERROR;

	if (KeySize < CE2_AES_Key128BitSize || 
		KeySize > CE2_AES_Key256BitSize)
		return CE2_XTS_AES_ILLEGAL_ENCRYPT_MODE_ERROR;

	if (EncryptDecryptFlag < CE2_AES_Encrypt || 
		EncryptDecryptFlag > CE2_AES_Decrypt)
		return CE2_XTS_AES_ILLEGAL_KEY_SIZE_ERROR;

	if (DataIn_ptr == DX_NULL) 
		return CE2_XTS_AES_ILLEGAL_DATAIN_PTR_ERROR;

	if(DataInSize < CE2_AES_BLOCK_SIZE_IN_BYTES)
		return CE2_XTS_AES_TO_SHORT_DATA_SIZE_ERROR;

	if (DataOut_ptr == DX_NULL) 
		return CE2_XTS_AES_ILLEGAL_DATAOUT_PTR_ERROR;

	return LLF_XTS_AES(Key1_ptr, Key2_ptr, KeySize, SectorNumber, 
		EncryptDecryptFlag, DataIn_ptr, DataInSize, DataOut_ptr);
} /* End of DX_XTS_AES */

